/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-04-27
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HVTFAIterator.h"
#include "HVTFAStationSignals.h"

/*!
  \class HVTFAIterator HVTFAIterator.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
HVTFAIterator::HVTFAIterator(const QList<HVTFAStationSignals *> *  stations,
                             const TimeRangeParameters * globalRange)
{
  TRACE;
  _stations=stations;
  _globalRange=globalRange;

  _currentStation=0;
  _currentRange=0;
  if(_currentStation<_stations->count()) {
    setRangeList();
  }
}

/*!
  Set range list for current station.

  \internal
*/
void HVTFAIterator::setRangeList()
{
  TRACE;
  const StationSignals * stat=_stations->at(_currentStation)->originalSignals();
  TimeRange r=_globalRange->absoluteRange(stat);
  _rangeList=stat->timeRange(r).ranges();
  _currentRange=0;
}

/*!
  Returns true if there is no more range nor station to process.
*/
bool HVTFAIterator::atEnd() const
{
  TRACE;
  if(_currentRange<_rangeList.count()) {
    return false;
  } else {
    return _currentStation>=_stations->count();
  }
}

/*!
  Switch to next range or station.
*/
void HVTFAIterator::next()
{
  TRACE;
  _currentRange++;
  if(_currentRange>=_rangeList.count()) {
    _currentStation++;
    if(_currentStation<_stations->count()) {
      setRangeList();
    } else {
      _rangeList.clear();
    }
  }
}
