/***************************************************************************
**
**  This file is part of gptarget.
**
**  gptarget is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gptarget is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-28
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTTARGET_H
#define ABSTRACTTARGET_H

#include <QtCore>

class AbstractTarget
{
public:
  AbstractTarget() {}
  virtual ~AbstractTarget() {}

  virtual bool setOptions(int& argc, char ** argv)=0;
  virtual int execute()=0;

  void setFileName(const QString& f) {_fileName=f;}
  const QString& fileName() const {return _fileName;}
private:
  QString _fileName;
};

#endif // ABSTRACTTARGET_H
