/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreWave.h>
#include "ModelSliderEditor.h"

/*!
  \class ModelSliderEditor ModelSliderEditor.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ModelSliderEditor::ModelSliderEditor(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
ModelSliderEditor::~ModelSliderEditor()
{
  TRACE;
}

void ModelSliderEditor::setModelType(GeophysicalModel * m)
{
  GeophysicalModel::GeophysicalContext * context=m->expressionContext();
  context->addVariable("p", 0.0);
  codeEdit->setContext(*context);
  delete context;
}

QString ModelSliderEditor::title() const
{
  TRACE;
  return titleEdit->text();
}

void ModelSliderEditor::setTitle(const QString& t)
{
  TRACE;
  return titleEdit->setText(t);
}


QString ModelSliderEditor::code() const
{
  TRACE;
  return codeEdit->text();
}

void ModelSliderEditor::setCode(const QString& t)
{
  TRACE;
  codeEdit->setText(t);
}
