/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MODELWORKER_H
#define MODELWORKER_H

#include <DinverDCCore.h>

#include "GridGenerator.h"

class Reader;

class ModelWorker : public LoopWorker
{
public:
  ModelWorker(const Reader * p, const GridGenerator * gg);
  ~ModelWorker();
protected:
  virtual void run(int index);
private:
  const Reader * _parameters;
  ParamGroundModel _groundModel;
  RealSpace _parameterSpace;
  TargetList _targets;
  ParamProfile * _vp, * _nu, * _vs, * _rho;
  PoissonCondition * _poissonCondition;
  const GridGenerator * _mainGenerator;
};

#endif // MODELWORKER_H
