/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-06
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SOURCEITEMMODEL_H
#define SOURCEITEMMODEL_H

#include <QGpGuiTools.h>

#include "SourceParameters.h"

class SourceItemModel : public QAbstractTableModel
{
public:
  SourceItemModel(QList<SourceParameters> * sources, QObject * parent=nullptr);
  ~SourceItemModel();

  void setWaveModel(SourceParameters::WaveModel wm);

  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual bool setData (const QModelIndex & index, const QVariant & value, int role);
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  virtual Qt::ItemFlags flags (const QModelIndex & ) const;

  void setSources(QList<SourceParameters>& sources);
  void addSource();
  void removeSource(int index);
private:
  int colorColumn() const;

  QList<SourceParameters> * _sources;
  SourceParameters::WaveModel _waveModel;
};

#endif // SOURCEITEMMODEL_H
