/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-13
**  Copyright: 2007-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MEDIUMPARAMETERS_H
#define MEDIUMPARAMETERS_H

class MediumParameters
{
public:
  MediumParameters();

  void setFrequency(double f) {_frequency=f;}
  double frequency() const {return _frequency;}

  void setAttenuation(double Q) {_attenuation=Q;}
  double attenuation() const {return _attenuation;}
private:
  double _frequency;
  double _attenuation;
};

#endif // MEDIUMPARAMETERS_H
