/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TFAResults_H
#define TFAResults_H

#include <GeopsyGui.h>

class TFAParameters;

class TFAResults : public GraphicSheetMenu
{
  Q_OBJECT
public:
  TFAResults(QWidget* parent=0);
  ~TFAResults();

  void compute(int ig, Signal *sig, TFAParameters &param);
  void createObjects(const SubSignalPool* subPool);
  void setWindowTitle(QString title) {GraphicSheetMenu::setWindowTitle(title);}
private:
  QVector<IrregularGrid2DPlot *> _gridLayers;
};

#endif
