/***************************************************************************
**
**  This file is part of geopsyptmotion.
**
**  geopsyptmotion is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyptmotion is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ToolPtMotiond.h"

/*!
  Constructs a ToolPtMotiond as a child of 'parent', with the
  name 'name' and widget flags set to 'f'.
*/
ToolPtMotiond::ToolPtMotiond(QWidget *parent, Qt::WindowFlags f)
    : QWidget(parent, f)
{
  TRACE;
  setupUi(this);
}

/*!
  Destroys the object and frees any allocated resources
*/
ToolPtMotiond::~ToolPtMotiond()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}

void ToolPtMotiond::on_vertical_toggled()
{
  TRACE;
  azimuth->setEnabled(vertical->isChecked());
}

void ToolPtMotiond::on_doFilterBut_stateChanged()
{
  TRACE;
  filterWidget->setEnabled(doFilterBut->isChecked());
}
