/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-14
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "HVPlugin.h"
#include "HVStation.h"
#include "HVToolWidget.h"
#include "SpectrumRotateToolWidget.h"
#include "HVRotateToolWidget.h"
#include "SpectrumToolWidget.h"
#include "TabHVPreferences.h"

#include "geopsyhvInstallPath.h"
#include "geopsyhvVersion.h"
#include "GeopsyCoreVersion.h"

const char * HVPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void HVPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("Spectrum"));
  a->setIcon(QIcon(":spectrum-22x22.png"));
  a->setStatusTip(tr("Smoothed amplitude spectrum."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);

  a=new QAction(toolFactory);
  a->setText(tr("H/V"));
  a->setIcon(QIcon(":hv-22x22.png"));
  a->setStatusTip(tr("Horizontal to vertical ratio for ambient vibrations."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);

  a=new QAction(toolFactory);
  a->setText(tr("Spectrum Rotate"));
  a->setIcon(QIcon(":spectrumrotate-22x22.png"));
  a->setStatusTip(tr("Smoothed horizontal amplitude spectrum, scans in all directions."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);

  a=new QAction(toolFactory);
  a->setText(tr("H/V Rotate"));
  a->setIcon(QIcon(":hvrotate-22x22.png"));
  a->setStatusTip(tr("Horizontal to vertical ratio for ambient vibrations, scans in all directions for the horizontal component."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * HVPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new SpectrumToolWidget(wsParent);
    break;
  case 1:
    return new HVToolWidget(wsParent);
    break;
  case 2:
    return new SpectrumRotateToolWidget(wsParent);
    break;
  case 3:
    return new HVRotateToolWidget(wsParent);
    break;
  default:
    break;
  }
  return 0;
}

/*!
  Add a new tab to Preference tabWidget
*/
void HVPlugin::addPreferenceTab(QTabWidget * parent)
{
  TRACE;
  _tab=new TabHVPreferences();
  parent->addTab(_tab,tr("HV"));
}

/*!
  Set properties of the HV tab
*/
void HVPlugin::setPreferences()
{
  TRACE;
  if(!_tab) return;
  _tab->setPreferences();
  _tab=0;
}

PACKAGE_INFO("geopsyhv", GEOPSYHV)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(geopsyhv, HVPlugin)
#endif
