/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-03-24
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMETERS_H
#define PARAMETERS_H

#include <GeopsyCore.h>

class Parameters : public AbstractParameters
{
public:
  Parameters();
  Parameters(const Parameters& o);
  ~Parameters();

  virtual AbstractParameters * clone() const {return new Parameters(*this);}

  bool isFilter() const {return _filter;}
  FilterParameters& filter();
  const FilterParameters& filter() const;
  void setFilter(const FilterParameters& f);

  TimeRangeParameters& timeRange() {return _timeRange;}
  const TimeRangeParameters& timeRange() const {return _timeRange;}
  void setTimeRange(const TimeRangeParameters& t) {_timeRange=t;}

  const double& windowLength() const {return _windowLength;}
  void setWindowLength(const double& w) {_windowLength=w;}

  const double& fitLength() const {return _fitLength;}
  void setFitLength(const double& f) {_fitLength=f;}

  virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
protected:
  virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
  virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
private:
  FilterParameters * _filter;
  TimeRangeParameters _timeRange;
  double _windowLength;
  double _fitLength;
};

#endif // PARAMETERS_H

