/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-03
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKTIMEWINDOWS_H
#define FKTIMEWINDOWS_H

#include <ArrayCore.h>
#include <ArrayGui.h>
#include <GeopsyGui.h>

#include "ui_FKTimeWindows.h"

class FKMeshLayer;

class FKTimeWindows : public QWidget, public Ui::FKTimeWindows
{
  Q_OBJECT
public:
  FKTimeWindows(QWidget * parent=nullptr);
  ~FKTimeWindows();

  void setTimeWindowLayer(TimeWindowLayer * twLayer);

  bool setParameters(const ArraySelection * array, double frequency, FKParameters * param);
  void setGrid(FKParameters * param);
  TimeWindowList& timeWindowList() const {return static_cast<TimeWindowList&>(_timeWindows->list());}

  const FKCrossSpectrum * crossSpectrum() const {return _crossSpectrum;}

  void viewKxCurve();
  void viewKxKyGrid();
  void viewKEllGrid();

private slots:
  void setCurrentBlockSet();

  void on_showPeaksEdit_toggled(bool checked);
  void on_kEdit_valueChanged(const QString & );
  void on_vEdit_valueChanged(const QString & );
  void on_plotOption_currentIndexChanged(int index);
  void on_ellipticity_valueChanged(double value);
  void on_direction_valueChanged(double value);

  void currentVelocitySlowness(QPoint mousePos);
  void kxkyChanged();
private:
  void highLightWindows(TimeWindowList& winList);
  void setPlotOptions();
  void setPlotOption();
  void setKxKyGridLimits();
  void setKEllGridLimits();
  void setKxCurveLimits();
  void setPowerLimits();
  void setPowerConcaveMaskLimits();
  void setPowerGradientLimits();
  void setPowerStepLimits();
  void setPowerDirectionLimits();
  void setPowerEllStepLimits();
  void setEllipticityLimits();
  void setBlockSetList(const BlockAveragingParameters& param);
  void showFKPeaks();

  FKTaskManager * _taskManager;
  FKCrossSpectrum * _crossSpectrum;
  ArrayTimeWindows * _timeWindows;
  FKCache * _gridCache;

  TimeWindowLayer * _timeWindowLayer;

  LiveGridLayer * _gridLayer;
  LiveCurveLayer * _curveLayer;
  MeshLayer * _fkMeshLayer;
  CircleViewer * _fkSlowCircleLayer;
  LineLayer * _fkSlowLineLayer;
  LineLayer * _fkPeaks;

  ColorMap _positiveMap;
  ColorMap _positiveNegativeMap;

  int _currentBlockSet;
  QVector<QVector<int>> _blockSetList;
  static const Color _highLightedColor;
};

#endif // QTBFKTIMEWINDOWS_H
