/***************************************************************************
**
**  This file is part of geopsyarray.
**
**  geopsyarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-27
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKRESULTS_H
#define ACTIVEFKRESULTS_H

#include <ArrayCore.h>
#include <QGpGuiWave.h>
#include <SciFigs.h>

class ActiveFKResults : public GraphicSheetMenu
{
  Q_OBJECT
public:
  ActiveFKResults(QWidget* parent=nullptr);
  ~ActiveFKResults();

  void createObjects(ActiveFKToolSet * arrays);
  void setXAxis(const SamplingParameters& s);
  void setYAxis(Scale::Type t, double min, double max);
  void setWaveLengthLimit(int ig, double wl);
  void setLimits();
  IrregularGrid2DPlot * gridLayer(int index) const {return _gridLayers[index];}
  LineLayer * curveLayer(int index) const {return _curveLayers[index];}
public slots:
  void setPick(bool on);
  void autoPick();
  void adjust(int ig, ModalCurve& curve, double min, double max, SamplingOptions options);
  void stackGrids();
  void exportCurves();
signals:
  void newPlot(LineLayer * curveLayer, QString caption);
  void newCurve(int iGraph, ModalLine * line);
private:
  bool selectAll(QString title);
  ModalLine * createReferenceLine();

  QVector<IrregularGrid2DPlot *> _gridLayers;
  QVector<LineLayer *> _curveLayers;
  QVector<DispersionLimitLayer *> _limitLayers;
};

#endif // ACTIVEKRESULTS_H
