/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <math.h>

#include <GeopsyCore.h>
#include "RotateComponents.h"

/*!
  Constructs a RotateComponents as a child of \a parent, with
  widget flags set to \a fl.
*/
RotateComponents::RotateComponents(QWidget *parent, Qt::WindowFlags f)
    : Dialog(parent, f)
{
  TRACE;
  setupUi(this);
}

void RotateComponents::updateAll()
{
  TRACE;
  on_rZAxis_stateChanged(0);
  on_rNAxis_stateChanged(0);
  on_rEAxis_stateChanged(0);
}

void RotateComponents::on_rZAxis_stateChanged(int)
{
  TRACE;
  angZAxis->setEnabled(rZAxis->isChecked());
}

void RotateComponents::on_rNAxis_stateChanged(int)
{
  TRACE;
  angNAxis->setEnabled(rNAxis->isChecked());
}

void RotateComponents::on_rEAxis_stateChanged(int)
{
  TRACE;
  angEAxis->setEnabled(rEAxis->isChecked());
}

RotateParameters RotateComponents::parameters()
{
  TRACE;
  RotateParameters param;
  RotateParameters::Axes a=0;
  if(rZAxis->isChecked()) {
    a|=RotateParameters::Vertical;
    param.setAngleAroundVertical(angZAxis->value());
  }
  if(rNAxis->isChecked()) {
    a|=RotateParameters::North;
    param.setAngleAroundNorth(angNAxis->value());
  }
  if(rEAxis->isChecked()) {
    a|=RotateParameters::East;
    param.setAngleAroundEast(angEAxis->value());
  }
  param.setAxes(a);
  return param;
}
