/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-12-11
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "WindowEnvironment.h"
#include "MainWindow.h"
#include "dinverInstallPath.h"
#include "dinverVersion.h"

/*!
  \class WindowEnvironment WindowEnvironment.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
WindowEnvironment::WindowEnvironment()
  : MultiDocumentEnvironment()
{
  TRACE;

  createFileActions(); // Mostly not used except 'Open recent'
  createWindowsActions();
  createHelpActions();
}

/*!
  Description of destructor still missing
*/
WindowEnvironment::~WindowEnvironment()
{
  TRACE;
}

MultiDocumentWindow * WindowEnvironment::createWindow()
{
  MainWindow * mw=new MainWindow;
  return mw;
}

MainWindow * WindowEnvironment::window(const QObject *o)
{
  TRACE;
  return static_cast<MainWindow*>(MultiDocumentEnvironment::window(o));
}

MainWindow * WindowEnvironment::window(const QWidget * w)
{
  TRACE;
  return static_cast<MainWindow*>(MultiDocumentEnvironment::window(w));
}

QWidgetList WindowEnvironment::subWindowList(QWidget * parent)
{
  TRACE;
  WindowEnvironment * e=WindowEnvironment::instance();
  if(!parent) {
    parent=e->currentWindow();
  }
  MainWindow * mw=e->window(parent);
  QWidgetList wl;
  if(mw) {
    QList<MultiDocumentSubWindow *> l=mw->subWindowList();
    for(QList<MultiDocumentSubWindow *>::iterator it=l.begin(); it!=l.end(); it++) {
      wl.append((*it)->widget());
    }
  }
  return wl;
}

void WindowEnvironment::helpAbout()
{
  TRACE;
  QString version("Version: ");
  version+=DINVER_VERSION;
  if(strlen(DINVER_DISTRIBUTION)>0) {
    version+=" (";
    version+=DINVER_DISTRIBUTION;
    version+=")";
  }
  Dialog * d=new Dialog(currentWindow());
  d->setWindowTitle(tr("About dinver"));
  d->setMinimumSize(500,300);
  QLabel * text=new QLabel;
  text->setTextFormat(Qt::RichText);
  text->setWordWrap(true);
  text->setOpenExternalLinks(true);
  text->setText(tr("<p>%1</p>"
                   "<p>Dinver is a framework for inversion problems. The core engine is a "
                   "Neighbourhood Algorithm originally proposed by Sambridge (1999), implemented in C++ "
                   "and improved by <a href=\"http://www.geopsy.org/#References\">Wathelet (2008)</a>.</p>"
                   "<p>Each specific inversion problem can be coded with a simple API and packaged in a "
                   "dynamic library (plugin).</p>"
                   "<p>Using, Copying and Modifying this program is granted to everyone under the terms "
                   "of the GNU Public License version 3. <b>However, we would appreciate that you properly "
                   "reference this work, released for free, in all your publications or reports achieved "
                   "with this software.</b></p>"
                   "<p>This program is provided AS IS with NO WARRANTY OF ANY KIND, "
                   "INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS "
                   "FOR A PARTICULAR PURPOSE.</p>").arg(version));
  d->setMainWidget(text, Dialog::Close);
  d->exec();
  delete d;
}
