/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SelectPSViewer.h"
#include "PSViewer.h"
#include "MainWindow.h"
#include "WindowEnvironment.h"
#include "Engine.h"

/*
 *  Constructs a SelectPSViewer as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
SelectPSViewer::SelectPSViewer(QWidget *parent, Qt::WindowFlags f)
    : Dialog(parent, f)
{
  TRACE;
    setupUi(this);
}

/*
 *  Destroys the object and frees any allocated resources
 */
SelectPSViewer::~SelectPSViewer()
{
  TRACE;
  // no need to delete child widgets, Qt does it all for us
}


void SelectPSViewer::on_isNewViewer_toggled(bool)
{
  TRACE;
  newViewCaption->setEnabled(isNewViewer->isChecked());
}

void SelectPSViewer::on_isAddToViewer_toggled(bool)
{
  TRACE;
  psViewerList->setEnabled(isAddToViewer->isChecked());
}

void SelectPSViewer::init(PSViewerList psViewerPtrList, InversionThread * models)
{
  TRACE;
  newViewCaption->setText(models->objectName());
  PSViewerList::iterator it;
  for(it=psViewerPtrList.begin();it!=psViewerPtrList.end();++it) {
    if(*((*it)->parameterList())==*models) {
      psViewerList->addItem((*it)->windowTitle());
      _selectedViewers.append(*it);
    }
  }
  if(_selectedViewers.size()==0) {
    psViewerList->setEnabled(false);
    isAddToViewer->setEnabled(false);
    isNewViewer->setChecked(true);
  }
  else {
    isAddToViewer->setChecked(true);
    psViewerList->item(0)->setSelected(true);
  }
}

void SelectPSViewer::on_isNewViewer_clicked()
{
  TRACE;
  isNewViewer->setChecked(true);
  isAddToViewer->setChecked(false);
}

void SelectPSViewer::on_isAddToViewer_clicked()
{
  TRACE;
  isNewViewer->setChecked(false);
  isAddToViewer->setChecked(true);
}

PSViewer * SelectPSViewer::result()
{
  TRACE;
  if(isNewViewer->isChecked()) {
    PSViewer * w=new PSViewer;
    w->setObjectName("PSViewer");
    w->setWindowTitle(newViewCaption->text());
    connect(&WindowEnvironment::window(this)->bigBen(),SIGNAL(synchroTimeout()),w,SLOT(synchronize()));
    Engine::instance()->addSubWindow(this, w);
    return w;
  }
  else {
    int sel=0;
    for(int i=psViewerList->count()-1;i>=0;i--) {
      if(psViewerList->item(i)->isSelected()) sel=i;
    }
    return _selectedViewers[sel];
  }
}

