/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-09-17
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ModelSelector.h"

/*!
  \class ModelSelector ModelSelector.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ModelSelector::ModelSelector(QWidget * parent, Qt::WindowFlags f)
  : QDialog(parent, f)
{
  TRACE;
  setLayout(new QGridLayout);
  setAttribute(Qt::WA_DeleteOnClose, false);
}

/*!
  Description of destructor still missing
*/
ModelSelector::~ModelSelector()
{
  TRACE;
}

void ModelSelector::setParameterList(const InversionThread * t)
{
  TRACE;
  _thread=t;
  QGridLayout * layout=static_cast<QGridLayout *>(QWidget::layout());
  int n=t->variableParameterCount();
  for(int i=0; i<n; i++) {
    const Parameter * p=_thread->variableParameter(i);
    QLabel * l;
    if(p->unit().isEmpty()) {
      l=new QLabel(p->name(), this);
    } else {
      l=new QLabel(p->name()+" ["+p->unit()+"]", this);
    }
    layout->addWidget(l, i, 0);
    QSlider * slider=new QSlider(Qt::Horizontal, this);
    slider->setMinimum(0);
    slider->setMaximum(p->gridCount()-1);
    connect(slider, SIGNAL(valueChanged(int)), this, SLOT(sliderChanged(int)));
    layout->addWidget(slider, i, 1);
    QLineEdit * valueDisplay=new QLineEdit(this);
    valueDisplay->setReadOnly(true);
    valueDisplay->setText(QString::number(p->realValue(0)));
    layout->addWidget(valueDisplay, i, 2);
    DoubleSpinBox * width=new DoubleSpinBox(this);
    width->setMinimum(0.0);
    width->setMaximum(p->maximum()-p->minimum());
    width->setValue(width->maximum());
    connect(width, SIGNAL(valueChanged(double)), this, SLOT(widthChanged(double)));
    layout->addWidget(width, i, 3);
  }
  // Browsing history
  QLabel * l;
  QSlider * slider;

  l=new QLabel(tr("Minimum index"), this);
  layout->addWidget(l, n, 0);
  slider=new QSlider(Qt::Horizontal, this);
  slider->setMinimum(0);
  slider->setMaximum(t->expectedModelCount());
  slider->setValue(0);
  slider->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
  connect(slider, SIGNAL(valueChanged(int)), this, SIGNAL(setMinimumIndex(int)));
  layout->addWidget(slider, n, 1, 1, 3);

  l=new QLabel(tr("Maximum index"), this);
  layout->addWidget(l, n+1, 0);
  slider=new QSlider(Qt::Horizontal, this);
  slider->setMinimum(0);
  slider->setMaximum(t->expectedModelCount());
  slider->setValue(slider->maximum());
  slider->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
  connect(slider, SIGNAL(valueChanged(int)), this, SIGNAL(setMaximumIndex(int)));
  layout->addWidget(slider, n+1, 1, 1, 3);
}

void ModelSelector::sliderChanged(int value)
{
  QSlider * slider=qobject_cast<QSlider *>(sender());
  if(!slider) {
    return;
  }
  QGridLayout * layout=static_cast<QGridLayout *>(QWidget::layout());
  int layoutIndex=layout->indexOf(slider);
  int paramIndex, dummy;
  layout->getItemPosition(layoutIndex, &paramIndex, &dummy, &dummy, &dummy);
  const Parameter * p=_thread->variableParameter(paramIndex);
  QLineEdit * valueDisplay=static_cast<QLineEdit *>(layout->itemAtPosition(paramIndex, 2)->widget());
  valueDisplay->setText(QString::number(p->realValue(value)));
  setRange(paramIndex);
}

void ModelSelector::widthChanged(double)
{
  DoubleSpinBox * width=qobject_cast<DoubleSpinBox *>(sender());
  if(!width) {
    return;
  }
  QGridLayout * layout=static_cast<QGridLayout *>(QWidget::layout());
  int layoutIndex=layout->indexOf(width);
  int paramIndex, dummy;
  layout->getItemPosition(layoutIndex, &paramIndex, &dummy, &dummy, &dummy);
  setRange(paramIndex);
}

void ModelSelector::setRange(int paramIndex)
{
  QGridLayout * layout=static_cast<QGridLayout *>(QWidget::layout());
  const Parameter * p=_thread->variableParameter(paramIndex);
  QSlider * slider=static_cast<QSlider *>(layout->itemAtPosition(paramIndex, 1)->widget());
  DoubleSpinBox * width=static_cast<DoubleSpinBox *>(layout->itemAtPosition(paramIndex, 3)->widget());
  double value=p->realValue(slider->value());
  emit setRange(paramIndex, value, value+width->value());
}
