/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PointProperties.h"

namespace SciFigs {

PointProperties::PointProperties(QWidget * parent,
                                       QVector<QString> * names,
                                       QVector<QColor> * colors,
                                       QVector<int> * indexList)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
  nameTable->setEditTriggers(QAbstractItemView::AllEditTriggers);
  int n=indexList->size();
  nameTable->setRowCount(n);
  int i;
  for(i=0;i<n;i++) {
    int index=indexList->at(i);
    nameTable->item(i,0)->setText(QString::number(index));
    nameTable->item(i,1)->setText(names->at(index));
    nameTable->item(i,2)->setBackground(colors->at(index));
    nameTable->item(i,2)->setFlags(Qt::ItemIsEnabled);
  }
  nameTable->hideColumn(0);
  for(i=1;i<5;i++) nameTable->resizeColumnToContents(i);
}

PointProperties::~PointProperties()
{
  TRACE;

}

void PointProperties::on_colorBut_clicked()
{
  TRACE;
  // Get first selected row
  int sel=0;
  int n=nameTable->rowCount();
  while(!nameTable->item(sel,0)->isSelected() && sel<n) sel++;
  if(sel==n) return;
  QColor c=QColorDialog::getColor(nameTable->item(sel,2)->background().color(),this);
  if(c.isValid()) {
    while(sel<n) {
      nameTable->item(sel,2)->setBackground(c);
      sel++;
      while(!nameTable->item(sel,0)->isSelected() && sel<n) sel++;
    }
  }
}

void PointProperties::on_deleteBut_clicked()
{
  TRACE;
  int sel=0;
  int n=nameTable->rowCount();
  while(sel<n) {
    while(!nameTable->item(sel,0)->isSelected() && sel<n) sel++;
    if(sel<n) {
      for(int i=1;i<2;i++) nameTable->item(sel,i)->setFlags((Qt::ItemFlags)0);
      sel++;
    }
  }
}

void PointProperties::getResults(QVector<double> * x,
                                    QVector<double> * y,
                                    QVector<QString> * names,
                                    QVector<QColor> * colors)
{
  TRACE;
  // Delete from the end to conserve the indexes
  for(int i=nameTable->rowCount()-1;i>=0;i--) {
    int index=nameTable->item(i,0)->text().toInt();
    if(nameTable->item(i,1)->flags() & Qt::ItemIsEnabled) {
      QColor c=nameTable->item(i,2)->background().color();
      int index=nameTable->item(i,0)->text().toInt();
      (*colors)[index]=c;
      (*names)[index]=nameTable->item(i,1)->text();
    } else {
      x->erase(x->begin()+index);
      y->erase(y->begin()+index);
      names->erase(names->begin()+index);
      colors->erase(colors->begin()+index);
    }
  }
}

void PointProperties::on_nameTable_itemClicked(QTableWidgetItem * item)
{
  TRACE;
  if(nameTable->column(item)==2) {
    QColor c=QColorDialog::getColor(item->background().color(),this);
    if(c.isValid()) item->setBackground(c);
  }
}


} // namespace SciFigs
