/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-26
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINEITEM_H
#define NAMELINEITEM_H

#include <QtGui>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class NameLineLayer;

class SCIFIGS_EXPORT NameLineItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  NameLineItem(QObject * parent=nullptr);
  ~NameLineItem() {}

  void setLayer(NameLineLayer * layer);
  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual Qt::ItemFlags flags (const QModelIndex & ) const;
private:
  NameLineLayer * _layer;
};

} // namespace SciFigs

#endif // NAMELINEITEM_H
