/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2002-10-03
**  Copyright: 2002-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LegendItem.h"

namespace SciFigs {

const QString LegendItem::xmlLegendItemTag="LegendItem";

LegendItem& LegendItem::operator=(const LegendItem& o)
{
  TRACE;
  _text=o._text;
  _textColor=o._textColor;
  _pen=o._pen;
  _symbol=o._symbol;
  return *this;
}

bool LegendItem::operator==(const LegendItem& o) const
{
  TRACE;
  return _text==o._text &&
         _textColor==o._textColor &&
         _pen==o._pen &&
         _symbol==o._symbol;
}

void LegendItem::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "text",_text);
  writeProperty(s, "textColor",_textColor.name());
}

void LegendItem::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  _pen.xml_save(s, context);
  _symbol.xml_save(s, context);
}

XMLMember LegendItem::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="text") return XMLMember(0);
  else if(tag=="textColor") return XMLMember(1);
  else if(tag=="Pen") return XMLMember(&_pen);
  else if(tag=="Symbol") return XMLMember(&_symbol);
  return XMLMember(XMLMember::Unknown);
}

bool LegendItem::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  switch(memberID) {
  case 0:
    _text=content.toString();
    return true;
  case 1: {
      QColor col(content.toString());
      _textColor=col;
    }
    return true;
  default:
    return false;
  }
}


} // namespace SciFigs
