/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-06
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICSHEETMENU_H
#define GRAPHICSHEETMENU_H

#include "GraphicSheet.h"
#include "Axis.h"

namespace SciFigs {

class SCIFIGS_EXPORT GraphicSheetMenu : public QWidget
{
  Q_OBJECT
public:
  GraphicSheetMenu(QWidget* parent=0, Qt::WindowFlags f=Qt::Widget);

  void removeObject(GraphicObject * o);

  QMenu * menuFile;
  QMenu * menuEdit;
  QMenu * menuInsert;
  QMenu * menuFormat;
  QMenu * addMenu(QString title);

  GraphicSheet * sheet() {return &_sheet;}
protected:
  // For layout definition (only x,y and dx, dy)
  void addActions();

  GraphicSheet _sheet;
  // Use this if you add a message bar or any other widget
  QVBoxLayout* _childLayout;
private:
#ifndef Q_OS_MAC
  QMenuBar * _menuBar;
#endif
};

} // namespace SciFigs

#endif // GRAPHICSHEETMENU_H
