/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-19
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXSTATISTICALLINE_H
#define COMPLEXSTATISTICALLINE_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT ComplexStatisticalLine : public AbstractLine
{
public:
  virtual AbstractLine * clone() const;
  virtual void operator=(const ComplexStatisticalLine& o);

  virtual const QString& xml_tagName() const {return xmlComplexStatisticalLineTag;}
  static const QString xmlComplexStatisticalLineTag;

  virtual int count() const {return _curve.count();}
  virtual void clear() {_curve.clear();}
  virtual void append() {_curve.append(ComplexStatisticalPoint());}
  virtual void insert(int index) {_curve.insert(index, ComplexStatisticalPoint());}
  virtual void removeLast() {_curve.remove(_curve.count()-1);}
  virtual bool isValid(int index) const {return _curve.isValid(index);}
  virtual void setValid(int index, bool v) {_curve.setValid(index, v);}
  virtual bool isSorted() const {return _curve.isSorted();}
  virtual void checkSort() {_curve.checkSort();}
  virtual void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    return _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  virtual Point point(int index, const CurvePointOptions * options) const;
  virtual void setX(int index, double v) {_curve.setX(index, v);}
  virtual void setY(int index, double v, const CurvePointOptions * options);
  virtual void setZ(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setStddev(v);}

  const Curve<ComplexStatisticalPoint>& curve() const {return _curve;}
  Curve<ComplexStatisticalPoint>& curve() {return _curve;}
  void setCurve(const Curve<ComplexStatisticalPoint>& curve) {_curve=curve;}
protected:
  Curve<ComplexStatisticalPoint> _curve;
};

} // namespace SciFigs

#endif // COMPLEXSTATISTICALLINE_H
