/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONLINE_H
#define REFRACTIONLINE_H

#include <QGpCoreWave.h>
#include <SciFigs.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT RefractionLine : public AbstractLine
{
  TRANSLATIONS("RefractionLine")
public:
  void operator=(const RefractionLine& o);
  virtual AbstractLine * clone() const;

  virtual const QString& xml_tagName() const {return xmlRefractionLineTag;}
  static const QString xmlRefractionLineTag;

  virtual int count() const {return _curve.count();}
  virtual void clear() {_curve.clear();}
  virtual void append() {_curve.append(FactoryPoint());}
  virtual void insert(int index) {_curve.insert(index, FactoryPoint());}
  virtual void removeLast() {_curve.remove(_curve.count()-1);}
  virtual bool isValid(int index) const {return _curve.isValid(index);}
  virtual void setValid(int index, bool v) {_curve.setValid(index,v);}
  virtual bool isSorted() const {return _curve.isSorted();}
  virtual void checkSort() {_curve.checkSort();}
  virtual void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  virtual Point point(int index, const CurvePointOptions *) const;
  virtual void setX(int index, double v) {_curve.setX(index, v);}
  virtual void setY(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setMean(v);}
  virtual void setZ(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setStddev(v);}

  const RefractionCurve& curve() const {return _curve;}
  RefractionCurve& curve() {return _curve;}
  void setCurve(const RefractionCurve& curve) {_curve=curve;}
protected:
  RefractionCurve _curve;
};

} // namespace QGpGuiWave

#endif // REFRACTIONLINE_H
