/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-08
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODEITEM_H
#define MODEITEM_H

#include <QtGui>
#include <QGpCoreWave.h>

#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

  class QGPGUIWAVE_EXPORT ModeItem: public QAbstractTableModel
  {
    Q_OBJECT
  public:
    ModeItem(QObject * parent=nullptr);
    ~ModeItem() {}

    void setProxy(ModalProxy * p);
    void setType(Mode::Type t);
    virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
    virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
    virtual Qt::ItemFlags flags (const QModelIndex & ) const {
      return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;
    }

    void add(const Mode &m);
    void remove(const QItemSelectionModel * selModel);

    void beginModeChange();
    void endModeChange();
  private:
    ModalProxy * _proxy;
    Mode::Type _type;
  };

} // namespace QGpGuiWave

#endif // MODEITEM_H
