/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "PropertyContext.h"
#include "PropertyProxy.h"

namespace QGpGuiTools {

  /*!
    \class PropertyContext PropertyContext.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  PropertyContext::PropertyContext()
  {
    TRACE;
    _proxy=0;
  }

  /*!
    Description of destructor still missing
  */
  PropertyContext::~PropertyContext()
  {
    TRACE;
    delete _proxy;
    _proxy=0;
  }

  /*!

  */
  void PropertyContext::initProxy()
  {
    TRACE;
    if(!_proxy) {
      _proxy=new PropertyProxy;
    }
  }

  /*!
    The title is grabbed from \a parentTitle. If it is empty it is search in its parents.
  */
  void PropertyContext::setPropertyTitle(QWidget * parentTitle)
  {
    TRACE;
    QString title;
    do {
      if(!parentTitle) break;
      title=parentTitle->windowTitle();
      parentTitle=parentTitle->parentWidget();
    } while(title.isEmpty());
    _proxy->setTitle(title);
  }

  void PropertyContext::raiseEditor(uint category)
  {
    TRACE;
    if(_proxy) {
      _proxy->raiseEditor(category);
    }
  }

} // namespace QGpGuiTools
