/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-07-19
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ProgressBar.h"

namespace QGpGuiTools {

  /*!
    \class ProgressBar Progressbar.h
    \brief Graphical progress bar for nested processes

    Update widget only every second. It can be shared by nested processes.
    Do not call setValue() with the maximum value twice.
  */

  /*!
    \fn ProgressBar::ProgressBar(QWidget * parent)
    Description of constructor still missing
  */
  ProgressBar::ProgressBar(QWidget * parent)
    : QProgressBar(parent)
  {
    AbstractProgress::setMaximum(0);
  }

  void ProgressBar::beginSubProgress(qint64 val)
  {
    if(val>0) {
      if(!atEnd()) {
        _states.append(State(AbstractProgress::value(), AbstractProgress::maximum()));
      }
      AbstractProgress::setMaximum(val);
      QProgressBar::setMaximum(val);
      QProgressBar::setValue(0);
    }
  }

  void ProgressBar::endSubProgress()
  {
    if(!_states.isEmpty()) {
      State& last=_states.top();
      AbstractProgress::setMaximum(last.maximum);
      QProgressBar::setMaximum(last.maximum);
      QProgressBar::setValue(last.value);
      _states.pop();
    }
  }

} // namespace QGpGuiTools
