/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-23
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FINDREPLACEWIDGET_H
#define FINDREPLACEWIDGET_H

#include "ui_FindReplaceWidget.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT FindReplaceWidget : public QWidget, private Ui::FindReplaceWidget
  {
    Q_OBJECT
  public:
    FindReplaceWidget(QWidget * parent=nullptr);
    ~FindReplaceWidget();

    void setHistoryBaseName(const QString& n);
  private slots:
    void on_nextButton_clicked();
    void on_previousButton_clicked();
    void on_replaceButton_clicked();
    void on_replaceAndFindButton_clicked();
    void on_replaceAllButton_clicked();
  private:
    void saveHistory();

    QString _historyBaseName;
  };

} // namespace QGpGuiTools

#endif // FINDREPLACEWIDGET_H
