/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-23
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FindReplaceWidget.h"
#include "Settings.h"

namespace QGpGuiTools {

  /*!
    \class FindReplaceWidget FindReplaceWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  FindReplaceWidget::FindReplaceWidget(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);
  }

  /*!
    Description of destructor still missing
  */
  FindReplaceWidget::~FindReplaceWidget()
  {
    TRACE;
  }

  void FindReplaceWidget::setHistoryBaseName(const QString& n)
  {
    TRACE;
    _historyBaseName=n;
    findEdit->clear();
    replaceEdit->clear();
    findEdit->addItems(Settings::getHistory(_historyBaseName+"Find"));
    replaceEdit->addItems(Settings::getHistory(_historyBaseName+"Replace"));
  }

  void FindReplaceWidget::saveHistory()
  {
    TRACE;
    ASSERT(!_historyBaseName.isEmpty());
    Settings::setHistory(_historyBaseName+"Find", findEdit->currentText());
    Settings::setHistory(_historyBaseName+"Replace", replaceEdit->currentText());
    setHistoryBaseName(_historyBaseName);
  }

  void FindReplaceWidget::on_nextButton_clicked()
  {
    TRACE;
    saveHistory();
  }

  void FindReplaceWidget::on_previousButton_clicked()
  {
    TRACE;
    saveHistory();
  }

  void FindReplaceWidget::on_replaceButton_clicked()
  {
    TRACE;
    saveHistory();
  }

  void FindReplaceWidget::on_replaceAndFindButton_clicked()
  {
    TRACE;
    saveHistory();
  }

  void FindReplaceWidget::on_replaceAllButton_clicked()
  {
    TRACE;
    saveHistory();
  }

} // namespace QGpGuiTools
