/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ExpressionEditor.h"

namespace QGpGuiTools {

/*!
  \class ExpressionEditor ExpressionEditor.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ExpressionEditor::ExpressionEditor(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);

  // Operator list is the same for all contexts
  operatorList->addItem("=");
  operatorList->addItem("+=");
  operatorList->addItem("-=");
  operatorList->addItem("*=");
  operatorList->addItem("/=");
  operatorList->addItem("+");
  operatorList->addItem("-");
  operatorList->addItem("*");
  operatorList->addItem("/");
  operatorList->addItem("DIV");
  operatorList->addItem("MOD");
  operatorList->addItem("==");
  operatorList->addItem("!=");
  operatorList->addItem("<");
  operatorList->addItem("<=");
  operatorList->addItem(">");
  operatorList->addItem(">=");
  operatorList->addItem("[0]");

  on_codeEdit_cursorPositionChanged ();
}

/*!
  Description of destructor still missing
*/
ExpressionEditor::~ExpressionEditor()
{
  TRACE;
}

void ExpressionEditor::setText(const QString& t)
{
  TRACE;
  codeEdit->setPlainText(t);
}

QString ExpressionEditor::text() const
{
  TRACE;
  return codeEdit->toPlainText();
}

void ExpressionEditor::setReadOnly(bool ro)
{
  TRACE;
  codeEdit->setReadOnly(ro);
}

void ExpressionEditor::setContext(const ExpressionContext& c)
{
  TRACE;
  QStringList variables=c.variables();
  for(QStringList::iterator it=variables.begin(); it!=variables.end(); it++ ) {
    variableList->addItem( *it);
  }

  QStringList functions=c.functions();
  for(QStringList::iterator it=functions.begin(); it!=functions.end(); it++ ) {
    functionList->addItem( *it);
  }
}

void ExpressionEditor::on_variableList_activated(int index)
{
  TRACE;
  if(!codeEdit->isReadOnly()) {
    codeEdit->insertPlainText(variableList->itemText(index));
  }
}

void ExpressionEditor::on_operatorList_activated(int index)
{
  TRACE;
  if(!codeEdit->isReadOnly()) {
    codeEdit->insertPlainText(operatorList->itemText(index));
  }
}

void ExpressionEditor::on_functionList_activated(int index)
{
  TRACE;
  if(!codeEdit->isReadOnly()) {
    codeEdit->insertPlainText(functionList->itemText(index));
  }
}

void ExpressionEditor::on_codeEdit_cursorPositionChanged ()
{
  TRACE;
  QTextCursor tc=codeEdit->textCursor();
  QTextBlock blk=tc.block();
  // Count the number of lines
  int i=0;
  while(blk.isValid()) {
    blk=blk.previous();
    i++;
  }
  textCursorPos->setText(QString("(%1, %2)")
    .arg(i)
    .arg(tc.position()-tc.block().position()+1));
}

} // namespace QGpGuiTools
