/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-03
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "DoubleSpinBox.h"

namespace QGpGuiTools {

/*!
  \class DoubleSpinBox DoubleSpinBox.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
DoubleSpinBox::DoubleSpinBox(QWidget * parent)
    : QDoubleSpinBox(parent)
{
  TRACE;
  switch(rand()%3) {
  default:
    setToolTip(tr("Need more precision? Press ALT while rolling wheel button."));
    break;
  case 1:
    setToolTip(tr("Need a smaller step? Press SHIFT while rolling wheel button."));
    break;
  case 2:
    setToolTip(tr("Need a temporary bigger step? Press CTRL while rolling wheel button."));
    break;
  }
}

/*!
  Return the current value. If \a expectedValue is within the current precision of current value,
  the expected value is returned rather than the rounded current value.
*/
double DoubleSpinBox::value(double expectedValue) const
{
  // getting precision
  if(fabs((value()-expectedValue)*pow(10.0, decimals()))>1.0) {
    return value();
  } else {
    return expectedValue;
  }
}

/*!
  Let user change the precision and step (alt and shift, respectively)
*/
void DoubleSpinBox::wheelEvent(QWheelEvent *event)
{
  TRACE;
  if(event->modifiers() & Qt::ShiftModifier) {
    if(event->angleDelta().y()>0) {
      setSingleStep(singleStep()*10.0);
    } else {
      if(singleStep()>=pow(0.1,decimals()-1)) {
        setSingleStep(singleStep()*0.1);
      }
    }
    showToolTip(tr("Step=%1").arg(singleStep()));
    event->accept();
  } else if(event->modifiers() & Qt::AltModifier) {
    if(event->angleDelta().x()>0) {  // Noticed that x is required when ALT is pressed
      setDecimals(decimals()+1);
    } else {
      setDecimals(decimals()-1);
    }
    showToolTip(tr("Decimals=%1").arg(decimals()));
    event->accept();
  } else {
    QDoubleSpinBox::wheelEvent(event);
  }
}

void DoubleSpinBox::showToolTip(const QString& text)
{
  TRACE;
  QToolTip::showText(mapToGlobal(QPoint()), text, this);
}

} // namespace QGpGuiTools
