/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT DockWidget : public QDockWidget
  {
    Q_OBJECT
  public:
    DockWidget(QWidget * parent=0, Qt::WindowFlags f=Qt::Widget) : QDockWidget(parent, f) {}
    ~DockWidget() {}
  protected:
    inline virtual void closeEvent(QCloseEvent * e);
  signals:
    void hidden();
  };

  inline void DockWidget::closeEvent(QCloseEvent * e)
  {
    TRACE;
    QDockWidget::closeEvent(e);
    emit hidden();
  }

} // namespace QGpGuiTools

#endif // DOCKWIDGET_H
