/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ColumnTextColumnsProperties.h"

namespace QGpGuiTools {

/*!
  \class ColumnTextColumnsProperties ColumnTextColumnsProperties.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ColumnTextColumnsProperties::ColumnTextColumnsProperties(QWidget * parent)
    : Dialog(parent)
{
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
ColumnTextColumnsProperties::~ColumnTextColumnsProperties()
{
}

void ColumnTextColumnsProperties::updateWidgets()
{
  on_delimitersOption_toggled();
  on_fixedWidthsOption_toggled();
}

void ColumnTextColumnsProperties::on_delimitersOption_toggled()
{
  bool b=delimitersOption->isChecked();
  tabDelimiter->setEnabled(b);
  spaceDelimiter->setEnabled(b);
  otherDelimiters->setEnabled(b);
  acceptNullColumns->setEnabled(b);
  maximumColumnCount->setEnabled(b);
  maximumColumnCountLabel->setEnabled(b);
}

void ColumnTextColumnsProperties::on_fixedWidthsOption_toggled()
{
  columnWidths->setEnabled(fixedWidthsOption->isChecked());
}

QString ColumnTextColumnsProperties::delimiters() const
{
  QString d;
  if(spaceDelimiter->isChecked()) d+=" ";
  if(tabDelimiter->isChecked()) d+="\t";
  d+=otherDelimiters->text();
  return d;
}

} // namespace QGpGuiTools
