/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-03-11
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GEOGRAPHICALREFERENCE_H
#define GEOGRAPHICALREFERENCE_H

#include <QtGui>
#include <QGpCoreMath.h>

#include "ui_GeographicalReference.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT GeographicalReference : public QWidget, private Ui::GeographicalReference
  {
    Q_OBJECT
  public:
    GeographicalReference(QWidget * parent=nullptr);
    ~GeographicalReference();

    Point2D reference() const;
    void setReference(const Point2D& p);
    void save();
  private slots:
    void on_refName_currentIndexChanged(int index);
  private:
    QList<NamedPoint> _references;
  };

} // namespace QGpGuiMath

#endif // GEOGRAPHICALREFERENCE_H
