/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-13
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PluginSettings.h"
#include "CoreApplication.h"

namespace QGpCoreTools {

  /*!
    \class PluginSettings PluginSettings.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  PluginSettings::PluginSettings()
  {
    _reg=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  PluginSettings::~PluginSettings()
  {
  }

  QStringList PluginSettings::paths() const
  {
    return _reg->value("paths").toStringList();
  }

  void PluginSettings::setPaths(const QStringList& paths)
  {
    _reg->setValue("paths", paths);
  }

  bool PluginSettings::hasPluginList() const
  {
    return _reg->contains("pluginList");
  }

  QStringList PluginSettings::pluginList() const
  {
    return _reg->value("pluginList").toStringList();
  }

  void PluginSettings::setPluginList(const QStringList& list)
  {
    _reg->setValue("pluginList", list);
  }

  void PluginSettings::clear()
  {
    _reg->remove("");
  }

} // namespace QGpCoreTools

