/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ParallelTask.h"
#include "ParallelTaskManager.h"

namespace QGpCoreTools {

  /*!
    \class ParallelTask ParallelTask.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ParallelTask::ParallelTask(ParallelTaskManager * parent, int taskIndex)
    : QObject(parent)
  {
    TRACE;
    _taskIndex=taskIndex;
    _processCount=0;
    _currentStep=0;
    _maxStep=0;
    _stepCount=0;
  }

  /*!
    Description of destructor still missing
  */
  ParallelTask::~ParallelTask()
  {
    TRACE;
    ASSERT(_processCount==0);
  }

  ParallelTaskManager * ParallelTask::taskManager() const
  {
    TRACE;
    return static_cast<ParallelTaskManager *>(parent());
  }

  void ParallelTask::init()
  {
    emit progressInit(_taskIndex, _stepCount);
#ifdef TASK_TIMING
    _chrono.start();
#endif
  }

  void ParallelTask::endProcess()
  {
    _processCount--;
    if(_currentStep>_maxStep) {
      _maxStep=_currentStep;
      if(_maxStep>_stepCount) {
        _maxStep=_stepCount;
      }
      emit progressChanged(_taskIndex, _maxStep);
    }
    APP_LOG(1, tr("  task index %1: progress %2 %\n").arg(_taskIndex)
            .arg(_currentStep/(0.01*_stepCount), 0, 'f', 0))
  }

  void ParallelTask::setFinishing()
  {
    _maxStep=_stepCount;
#ifdef TASK_TIMING
    App::log(tr("  task index %1: processed during %2 s\n")
             .arg(_taskIndex)
             .arg(0.001*_chrono.elapsed()));
#endif
    emit progressChanged(_taskIndex, _maxStep);
    APP_LOG(1, tr("  task index %1: progress 100 %\n").arg(_taskIndex))
  }

  void ParallelTask::setStatus(const QString& msg)
  {
    emit statusChanged(_taskIndex, msg);
  }

} // namespace QGpCoreTools

