/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-04-16
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARALLELEPIPED_H
#define PARALLELEPIPED_H

#include "Point.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Parallelepiped
  {
  public:
    Parallelepiped();
    inline Parallelepiped(const Point& p1, const Point& p2);
    Parallelepiped(const Parallelepiped& o);

    void setLimits(const Point& p1, const Point& p2);

    bool includes(const Point & p) const;
    inline bool includes(const Point& p1, const Point& p2) const;

    void add(const Point& p);

    double x1() const {return _x1;}
    double x2() const {return _x2;}
    double y1() const {return _y1;}
    double y2() const {return _y2;}
    double z1() const {return _z1;}
    double z2() const {return _z2;}
    double dx() const {return _x2-_x1;}
    double dy() const {return _y2-_y1;}
    double dz() const {return _z2-_z1;}

    QList<Point> vertice() const;
  protected:
    double _x1, _y1, _z1, _x2, _y2, _z2;
  };

  inline Parallelepiped::Parallelepiped(const Point& p1, const Point& p2)
  {
    setLimits(p1, p2);
  }

} // namespace QGpCoreMath

#endif // PARALLELEPIPED_H
