/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MatrixMultiply.h"

namespace QGpCoreMath {

/*!
  \class MatrixMultiply MatrixMultiply.h
  \brief Brief description of class still missing

  A cache for fast matrix multiplication. The maximum dimension is 256. The size occupied for one set
  of index is 12*n^3 (for squared matrices), 192 Mb for dimension equal to 256.
*/

IMPLEMENT_NUMERICALKEY(MatrixMultiplyKey)

MatrixMultiply::MatrixMultiply(MatrixMultiplyKey * key)
  : AbstractNumericalCache(key)
{
  _indexes=0;
}

MatrixMultiply::~MatrixMultiply()
{
  delete [] _indexes;
}

void MatrixMultiply::init()
{
  const MatrixMultiplyKey& mKey=static_cast<const MatrixMultiplyKey&>(key());
  ASSERT(mKey.nRows1()<256);
  ASSERT(mKey.commonDim()<256);
  ASSERT(mKey.nColumns2()<256);
  _indexes=new IndexMap[indexCount()];
  IndexMap * pIndex=_indexes;
  for(int i=0; i<mKey.nRows1(); i++) {
    for(int j=0; j<mKey.nColumns2(); j++) {
      int resultIndex=i+j*mKey.nRows1();
      int mIndex=j*mKey.commonDim();
      for(int k=0; k<mKey.commonDim(); k++) {
        (pIndex++)->set(resultIndex, i+k*mKey.nRows1(), k+mIndex);
      }
    }
  }
}

} // namespace QGpCoreMath
