/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-03-02
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GOOGLEEARTHKML_H
#define GOOGLEEARTHKML_H

#include <QGpCoreTools.h>

#include "NamedPoint.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT GoogleEarthKML : public XMLClass
  {
  public:
    class QGPCOREMATH_EXPORT Point: public XMLClass
    {
    public:
      Point();

      virtual const QString& xml_tagName() const {return xmlPointTag;}
      static const QString xmlPointTag;

      const ::QGpCoreMath::Point& coordinates() const {return _coordinates;}
      void setCoodinates(const ::QGpCoreMath::Point& p) {_coordinates=p;}
    protected:
      virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
      virtual XMLMember xml_member(XML_MEMBER_ARGS);
      virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    private:
      ::QGpCoreMath::Point _coordinates;
    };

    class QGPCOREMATH_EXPORT Placemark: public XMLClass
    {
    public:
      Placemark();

      virtual const QString& xml_tagName() const {return xmlPlacemarkTag;}
      static const QString xmlPlacemarkTag;

      void setName(const QString& n) {_name=n;}
      const QString& name() const {return _name;}

      const ::QGpCoreMath::Point& coordinates() const {return _point.coordinates();}
      void setCoordinates(const ::QGpCoreMath::Point& p) {_point.setCoodinates(p);}
    protected:
      virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
      virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
      virtual XMLMember xml_member(XML_MEMBER_ARGS);
      virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    private:
      QString _name;
      Point _point;
    };

    class QGPCOREMATH_EXPORT Folder: public TreeContainer
    {
    public:
      Folder(Folder * parent=0): TreeContainer(parent) {}
      ~Folder();

      virtual const QString& xml_tagName() const {return xmlFolderTag;}
      static const QString xmlFolderTag;

      void setName(const QString& n) {_name=n;}
      const QString& name() const {return _name;}

      void addPlacemark(Placemark * p) {_placemarks.append(p);}
      void clearPlacemarks();

      void collectPoints(QList<NamedPoint>& list) const;
    protected:
      virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
      virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
      virtual XMLMember xml_member(XML_MEMBER_ARGS);
      virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    private:
      QString _name;
      QList<Placemark *> _placemarks;
    };

    class QGPCOREMATH_EXPORT Document: public XMLClass
    {
    public:
      Document();

      virtual const QString& xml_tagName() const {return xmlDocumentTag;}
      static const QString xmlDocumentTag;

      void setName(const QString& n) {_name=n;}
      const QString& name() const {return _name;}

      QList<NamedPoint> points() const;

      const Folder * mainFolder() const {return &_root;}
      Folder * mainFolder() {return &_root;}
    protected:
      virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
      virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
      virtual XMLMember xml_member(XML_MEMBER_ARGS);
      virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
    private:
      QString _name;
      Folder _root;
    };

  public:
    GoogleEarthKML();

    virtual const QString& xml_tagName() const {return xmlGoogleEarthKMLTag;}
    static const QString xmlGoogleEarthKMLTag;

    bool save(const QString& fileName);

    Document& document() {return _document;}
    const Document& document() const {return _document;}

    virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
  protected:
    virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    virtual XMLMember xml_member(XML_MEMBER_ARGS);
  private:
    Document _document;
  };

} // namespace QGpCoreMath

#endif // GOOGLEEARTHKML_H
