/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-26
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CHEBYSHEVFILTER_H
#define CHEBYSHEVFILTER_H

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class ChebyshevFilter
  {
  public:
    ChebyshevFilter(int order, double rippleFactor);
    ChebyshevFilter(double wPass1, double wPass2, double wStop1, double wStop2,
                    double allowedPassRipple, double allowedStopRipple);
    ChebyshevFilter(double wPass, double wStop,
                    double allowedPassRipple, double allowedStopRipple);

    double value(double wR) const;
    double polynomial(double x) const;
  private:

    int _order;
    double _ripple;
  };

} // namespace QGpCoreMath

#endif // CHEBYSHEVFILTER_H

