/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTCOMPLEXPOINTOPTIONS_H
#define ABSTRACTCOMPLEXPOINTOPTIONS_H

#include <QGpCoreTools.h>

#include "CurvePointOptions.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT AbstractComplexPointOptions : public CurvePointOptions
{
public:
  AbstractComplexPointOptions() {}
  virtual ~AbstractComplexPointOptions() {}

  virtual double toDouble(double x, const Complex& c) const=0;
  virtual void fromDouble(double x, Complex& c, double v) const=0;
};

} // namespace QGpCoreMath

#endif // ABSTRACTCOMPLEXPOINTOPTIONS_H
