/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-22
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALREFINE_H
#define COMPATMODALREFINE_H

#include <QtCore>
#include <QGpCoreTools.h>

namespace QGpCompatibility {

class CompatModalRefine
{
public:
  CompatModalRefine(double omega, double val);
  CompatModalRefine(int nm) {_values.resize(nm);}
  ~CompatModalRefine() {}
  
  bool operator<(const CompatModalRefine& o) const;
  
  double& omega() {return _omega;}
  const double& omega() const {return _omega;}
  
  double& value(int im) {return _values[im];}
  const double& value(int im) const {return _values[im];}
private:
  double _omega;
  QVector<double> _values;
};

inline bool CompatModalRefine::operator<(const CompatModalRefine& o) const
{
  TRACE;
  return _omega<o._omega;
}


} // namespace QGpCompatibility

#endif // COMPATMODALREFINE_H
