/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <math.h>

#include <QGpCoreTools.h>
#include "CompatModalDispersion.h"
#include "CompatModalEllipticity.h"

namespace QGpCompatibility {

const QString CompatModalDispersion::xmlModalDispersionTag="ModalDispersion";

/*!
  \class CompatModalDispersion CompatModalDispersion.h
  \brief Calculate Love and Rayleigh dispersion curves and their misfits
  
  The main function used to calculate the dispersion curve is calculate().
  
  Misfits can be computed by misfit() or closestModeMisfit().
*/
  
// To be removed in the future, when Dinver will be completly finished
CompatDispersionData * CompatModalDispersion::oldStyle()
{
  TRACE;
  int nm=nModes();
  int nf=nOmegas();
  CompatDispersionData * disp=new CompatDispersionData(nm,nf);
  for(int i=0;i<nf;i++) {
    disp->setFrequency(i,omega(i)/(2*M_PI));
  }
  for(int im=0;im<nm;im++) {
    CompatVDataPointVector point=mode(im);
    for(int i=0;i<nf;i++) {
      disp->setMean(i,im,point[i].mean());
      disp->setStddev(i,im,point[i].stddev());
      disp->setWeight(i,im,point[i].weight());
      disp->setValue(i,im,point[i].value());
    }
  }
  return disp;
}


} // namespace QGpCompatibility
