/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-26
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ROTATERESULTSHEET_H
#define ROTATERESULTSHEET_H

#include "AbstractResultSheet.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT RotateResultSheet : public AbstractResultSheet
  {
  public:
    RotateResultSheet(QWidget * parent=nullptr);
    ~RotateResultSheet();

    void setStations(const QList<AbstractStation *>& stations);
    void setLimits(double maxAmplitude);
    void setValueTitle(const QString& t);
    void setLayout(int nPlotsPerLine, double pageHeight);
  protected:
    AbstractResultWidget * createWidget();
  private:
    ColorMapWidget * _colorMap;
  };

} // namespace HVGui

#endif // ROTATERESULTSHEET_H

