/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ROTATERESULTS_H
#define ROTATERESULTS_H

#include "AbstractResults.h"
#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT RotateResults : public AbstractResults
  {
  public:
    RotateResults(AbstractStation * parent);
    ~RotateResults();

    void clear();
    void setWindows(int winCount, const HVParameters& param);
    void setWindow(int azimuthIndex, double, const Curve<Point2D>& hv);
    int windowCount() const {return _windowCount;}
    void setStatistics();

    double maximumAmplitude() const;
    bool save(QString fileName, QString log) const;

    int azimuthCount() const {return _grid->ny();}
    double azimuth(int index) const {return _grid->y(index);}

    const IrregularGrid2D& grid() const {return *_grid;}
  private:
    IrregularGrid2D * _grid;
    GridParallelWriter * _gridAccess;
    int _windowCount;
  };

} // namespace HVCore

#endif // ROTATERESULTS_H

