/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-24
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FREQUENCYWINDOWREJECTION_H
#define FREQUENCYWINDOWREJECTION_H

#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT FrequencyWindowRejection : public AbstractParameters
  {
  public:
    FrequencyWindowRejection();
    FrequencyWindowRejection(const FrequencyWindowRejection& o);

    virtual AbstractParameters * clone() const {return new FrequencyWindowRejection(*this);}

    double minimumFrequency() const {return _minimumFrequency;}
    void setMinimumFrequency(double f) {if(f>0.0) _minimumFrequency=f;}

    double maximumFrequency() const {return _maximumFrequency;}
    void setMaximumFrequency(double f) {if(f>0.0) _maximumFrequency=f;}

    void checkFrequencyRange();

    double stddevFactor() const {return _stddevFactor;}
    void setStddevFactor(double s) {if(s>0.0) _stddevFactor=s;}

    int maximumIterationCount() const {return _maximumIterationCount;}
    void setMaximumIterationCount(int m) {if(m>0 && m<1000) _maximumIterationCount=m;}

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    double _minimumFrequency, _maximumFrequency;
    double _stddevFactor;
    int _maximumIterationCount;
  };

} // namespace HVCore

#endif // FREQUENCYWINDOWREJECTION_H


