/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  GeopsySLinkGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLinkGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSTREAMITEM_H
#define SEEDLINKSTREAMITEM_H

#include <GeopsySLink.h>

#include "GeopsySLinkGuiDLLExport.h"

namespace GeopsySLinkGui {

class GEOPSYSLINKGUI_EXPORT SeedLinkStreamItem : public QAbstractItemModel
{
public:
  SeedLinkStreamItem(QObject * parent=nullptr);
  ~SeedLinkStreamItem();

  void setServer(const SeedLinkServer * s);

  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  virtual QModelIndex parent (const QModelIndex & index) const;
  virtual QModelIndex index (int row, int column, const QModelIndex & parent=QModelIndex()) const;
  virtual Qt::ItemFlags flags (const QModelIndex & ) const {return Qt::ItemIsSelectable | Qt::ItemIsEnabled;}

  void commit(const QModelIndex& i) {emit dataChanged(index( i.row(), 0, parent(i)),
                                                          index(i.row(), columnCount(), parent(i)));}
  bool isStation(const QModelIndex& index) const;
  bool isStream(const QModelIndex& index) const;
  SeedLinkStation * station(const QModelIndex& index) const;
  SeedLinkStream * stream(const QModelIndex& index) const;
private:
  const SeedLinkServer * _server;
};

} // namespace GeopsySLinkGui

#endif // SEEDLINKSTREAMITEM_H
