/***************************************************************************
**
**  This file is part of GeopsyLand.
**
**  GeopsyLand is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyLand is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-03
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "GeopsyLandVersion.h"
#include "GeopsyLandInstallPath.h"
#include "MainWindow.h"

PACKAGE_INFO("GeopsyLand", GEOPSYLAND)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  Application a(argc, argv, help);

  MainWindow * w=new MainWindow;
  w->show();

  int appReturn=a.exec();
  delete w;
  return appReturn;
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]");
  h->setComments("");
  h->addGroup("GeopsyLand", "GeopsyLand");
  h->addOption("<short option>, <long option>","<comments>");
  return h;
}
