/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-06-14
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPARSETIMERANGEMODEL_H
#define SPARSETIMERANGEMODEL_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT SparseTimeRangeModel : public QAbstractTableModel
  {
    Q_OBJECT
  public:
    SparseTimeRangeModel(QObject * parent=nullptr);
    ~SparseTimeRangeModel();

    void setRange(SparseTimeRange * range, Mutex * mutex=nullptr);

    virtual int rowCount(const QModelIndex &) const {return rangeCount();}
    virtual int columnCount(const QModelIndex &) const;
    virtual QVariant data(const QModelIndex & index, int role=Qt::DisplayRole) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  public slots:
    void beginAddRange(int index);
    void endAddRange();
    void beginClearRange();
    void endClearRange();
  private:
    int rangeCount() const;

    SparseTimeRange * _range;
    mutable Mutex * _rangeMutex;
  };

} // namespace GeopsyGui

#endif // SPARSETIMERANGEMODEL_H
