/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HEADERWIDGET_H
#define HEADERWIDGET_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "ui_HeaderWidget.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT HeaderWidget : public Dialog, public Ui::HeaderWidget
  {
    Q_OBJECT

  public:
    HeaderWidget(SubSignalPool * subPool, QWidget* parent=0, Qt::WindowFlags f=Qt::Widget);
    ~HeaderWidget();
  private slots:
    void beginSignalChange(Signal * sig);
    void endSignalChange(Signal * sig);

    void on_loadBut_clicked();
    void on_saveBut_clicked();
    void on_applyBut_clicked();
    void on_debugBut_clicked();
  private:
    SubSignalPool * _subPool;
  };

} // namespace GeopsyGui

#endif // HEADERWIDGET_H
