/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GeopsyGuiEngine.h"
#include "LoadFormat.h"
#include "RD3LogParameter.h"
#include "TimeReference.h"

namespace GeopsyGui {

  /*!
    Ask for file format through a dialog box

    The value returned is the same as the one returned by the Core implementation. Combo box order must
    match the Core order.
  */
  SignalFileFormat GeopsyGuiEngine::askLoadFormat(const QString& signalFileName)
  {
    QSettings& reg=CoreApplication::instance()->settings();

    reg.beginGroup("DialogOptions");
    reg.beginGroup("LoadFormat");
    SignalFileFormat format=SignalFileFormat::Unknown;
    if(reg.value("again").toBool()) {
      LoadFormat * d=new LoadFormat(qApp->activeWindow());
      d->setSignalFileName(signalFileName);
      Settings::getWidget(d);
      if(d->exec()==QDialog::Accepted) {
        Settings::setWidget(d);
        format=d->format();
      }
      delete d;
    } else {
      int formatIndex=reg.value("fileFormat").toInt();
      QList< QPair<QString, SignalFileFormat> > formats=SignalFileFormat::importList();
      if(formatIndex>=formats.count() || formatIndex<0) formatIndex=0;
      format=formats.at(formatIndex).second;
    }
    return format;
  }

  bool GeopsyGuiEngine::askRD3LogParameter(int& nSamples, double& sampFreq, double& t0)
  {
    TRACE;
    RD3LogParameter * d= new RD3LogParameter(qApp->activeWindow());
    Settings::getWidget(d);
    if(d->exec()!=QDialog::Accepted) {
      delete d;
      return false;
    }
    Settings::setWidget(d);
    bool ok=false;
    nSamples= d->numSamp->text().toInt(&ok);
    if( !ok) {delete d; return false;}
    sampFreq= d->sampFreq->text().toDouble(&ok);
    if( !ok) {delete d; return false;}
    t0=d->t0->text().toDouble(&ok);
    if( !ok) {delete d; return false;}
    delete d;
    return true;
  }

} // namespace GeopsyGui
