/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-06-10
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "DeviceCardScanner.h"

namespace GeopsyCore {

  /*!
    \class DeviceCardScanner DeviceCardScanner.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  DeviceCardScanner::DeviceCardScanner(QObject * parent)
   : Thread(parent)
  {
    TRACE;
    _stopRequest=false;
    _stream=0;
  }

  /*!
    Description of destructor still missing
  */
  DeviceCardScanner::~DeviceCardScanner()
  {
    TRACE;
    clear();
  }

  void DeviceCardScanner::clear()
  {
    TRACE;
    cleanStop();
    if(_stream) {
      delete _stream;
      _stream=0;
    }
  }

  void DeviceCardScanner::cleanStop()
  {
    TRACE;
    if(isRunning()) {
      _stopRequest.fetchAndStoreOrdered(true);
      wait();
    }
  }

  bool DeviceCardScanner::isStopRequested()
  {
    TRACE;
    if(_stopRequest.testAndSetOrdered(true,true)) {
      stop();
      return true;
    } else {
      return false;
    }
  }

  void DeviceCardScanner::stop()
  {
    TRACE;
    delete _stream;
    _stream=0;
  }

  bool DeviceCardScanner::start()
  {
    TRACE;
    ASSERT(!_stream);
    QFile * f=stream(QIODevice::ReadOnly);
    if(!f) return false;
    _stream=f;
    _stopRequest=false;
    Thread::start();
    return true;
  }

} // namespace GeopsyCore
